<?php
use yii\widgets\ActiveForm;
use yii\widgets\MaskedInput;
use yii\helpers\Html;
use yii\web\View;

// Регистрируем CSS стили
$css = <<< CSS
/* Основные цвета */
:root {
    --primary-black: #121212;
    --secondary-black: #1a1a1a;
    --dark-gray: #2d2d2d;
    --light-gray: #444;
    --primary-pink: #e83e8c;
    --secondary-pink: #ff6b9d;
    --soft-pink: rgba(232, 62, 140, 0.1);
    --text-primary: #f8f9fa;
    --text-secondary: #b0b0b0;
    --border-color: #333;
    --hover-black: #252525;
    --success-color: #28a745;
    --accent-color: #6f42c1;
}

/* Контейнер формы регистрации */
.register-container {
    background-color: var(--primary-black);
    border-radius: 16px;
    padding: 40px 30px;
    box-shadow: 0 15px 35px rgba(0, 0, 0, 0.5);
    border: 1px solid var(--border-color);
    margin: 0 auto;
    position: relative;
    overflow: hidden;
    max-width: 480px;
    width: 100%;
}

.register-container::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 4px;
    background: linear-gradient(90deg, var(--primary-pink), var(--secondary-pink));
    z-index: 10;
}

.register-container::after {
    content: '';
    position: absolute;
    top: -50%;
    left: -50%;
    width: 200%;
    height: 200%;
    background: radial-gradient(circle, rgba(232, 62, 140, 0.05) 0%, rgba(232, 62, 140, 0) 70%);
    z-index: 0;
    pointer-events: none;
}

/* Заголовок формы */
.register-header {
    text-align: center;
    margin-bottom: 35px;
    position: relative;
    z-index: 1;
}

.register-title {
    color: var(--text-primary);
    font-size: 32px;
    font-weight: 600;
    margin-bottom: 10px;
    background: linear-gradient(135deg, var(--primary-pink), var(--secondary-pink));
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.register-subtitle {
    color: var(--text-secondary);
    font-size: 15px;
}

/* Анимация появления формы */
@keyframes fadeInRegister {
    from {
        opacity: 0;
        transform: translateY(30px) scale(0.95);
    }
    to {
        opacity: 1;
        transform: translateY(0) scale(1);
    }
}

.register-form-wrapper {
    animation: fadeInRegister 0.8s ease-out forwards;
    position: relative;
    z-index: 1;
}

/* Стили для полей ввода */
.form-group {
    margin-bottom: 25px;
    opacity: 0;
    animation: slideInField 0.5s ease-out forwards;
}

@keyframes slideInField {
    from {
        opacity: 0;
        transform: translateX(-20px);
    }
    to {
        opacity: 1;
        transform: translateX(0);
    }
}

/* Задержки для анимации полей */
.form-group:nth-child(1) { animation-delay: 0.1s; }
.form-group:nth-child(2) { animation-delay: 0.15s; }
.form-group:nth-child(3) { animation-delay: 0.2s; }
.form-group:nth-child(4) { animation-delay: 0.25s; }
.form-group:nth-child(5) { animation-delay: 0.3s; }
.form-group:nth-child(6) { animation-delay: 0.35s; }

.form-label {
    display: block;
    color: var(--text-primary);
    font-weight: 500;
    margin-bottom: 8px;
    font-size: 15px;
    position: relative;
    padding-left: 25px;
}

.form-label::before {
    position: absolute;
    left: 0;
    top: 50%;
    transform: translateY(-50%);
    font-size: 16px;
}

.field-fio .form-label::before {
    content: '👤';
}

.field-phone .form-label::before {
    content: '📱';
}

.field-email .form-label::before {
    content: '✉️';
}

.field-password .form-label::before {
    content: '🔒';
}

.field-password_repeat .form-label::before {
    content: '🔁';
}

/* Стили для инпутов */
.input-wrapper {
    position: relative;
}

.form-input {
    width: 100%;
    background-color: var(--dark-gray);
    border: 1px solid var(--border-color);
    color: var(--text-primary);
    border-radius: 10px;
    padding: 14px 45px 14px 15px;
    font-size: 15px;
    transition: all 0.3s ease;
    font-family: inherit;
}

.form-input:focus {
    border-color: var(--primary-pink);
    box-shadow: 0 0 0 3px rgba(232, 62, 140, 0.2);
    outline: none;
    background-color: var(--light-gray);
}

.form-input::placeholder {
    color: var(--text-secondary);
    opacity: 0.7;
}

/* Иконки в полях ввода */
.input-icon {
    position: absolute;
    right: 15px;
    top: 50%;
    transform: translateY(-50%);
    color: var(--text-secondary);
    font-size: 18px;
    pointer-events: none;
}

.field-fio .input-icon::after {
    content: '👤';
}

.field-phone .input-icon::after {
    content: '📞';
}

.field-email .input-icon::after {
    content: '📧';
}

.field-password .input-icon::after,
.field-password_repeat .input-icon::after {
    content: '👁️';
}

/* Стили для checkbox */
.checkbox-group {
    margin-top: 30px;
    padding: 20px;
    background-color: var(--secondary-black);
    border-radius: 10px;
    border: 1px solid var(--border-color);
    opacity: 0;
    animation: fadeInLink 0.5s ease-out 0.4s forwards;
}

.custom-checkbox {
    display: flex;
    align-items: flex-start;
    gap: 15px;
    cursor: pointer;
    user-select: none;
}

.checkbox-input {
    display: none;
}

.checkbox-box {
    min-width: 22px;
    height: 22px;
    border: 2px solid var(--border-color);
    border-radius: 6px;
    background-color: var(--dark-gray);
    position: relative;
    transition: all 0.3s ease;
    flex-shrink: 0;
    margin-top: 2px;
}

.checkbox-box::after {
    content: '✓';
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%) scale(0);
    color: white;
    font-weight: bold;
    font-size: 14px;
    transition: transform 0.2s ease;
}

.checkbox-input:checked + .checkbox-box {
    background-color: var(--primary-pink);
    border-color: var(--primary-pink);
    box-shadow: 0 0 10px rgba(232, 62, 140, 0.3);
}

.checkbox-input:checked + .checkbox-box::after {
    transform: translate(-50%, -50%) scale(1);
}

.checkbox-label {
    color: var(--text-primary);
    font-size: 14px;
    line-height: 1.5;
}

.checkbox-label a {
    color: var(--secondary-pink);
    text-decoration: none;
    transition: color 0.3s ease;
    position: relative;
}

.checkbox-label a::after {
    content: '';
    position: absolute;
    bottom: -2px;
    left: 0;
    width: 0;
    height: 1px;
    background: linear-gradient(90deg, var(--primary-pink), transparent);
    transition: width 0.3s ease;
}

.checkbox-label a:hover {
    color: var(--primary-pink);
}

.checkbox-label a:hover::after {
    width: 100%;
}

/* Кнопка регистрации */
.btn-register {
    background: linear-gradient(135deg, var(--primary-pink), var(--secondary-pink));
    color: white;
    border: none;
    border-radius: 10px;
    padding: 16px 30px;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 1px;
    font-size: 16px;
    transition: all 0.4s ease;
    box-shadow: 0 6px 20px rgba(232, 62, 140, 0.3);
    position: relative;
    overflow: hidden;
    display: block;
    width: 100%;
    cursor: pointer;
    margin: 25px 0;
    opacity: 0;
    animation: fadeInButton 0.5s ease-out 0.5s forwards;
}

@keyframes fadeInButton {
    from {
        opacity: 0;
        transform: translateY(10px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.btn-register::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
    transition: left 0.7s ease;
}

.btn-register:hover {
    transform: translateY(-3px);
    box-shadow: 0 12px 25px rgba(232, 62, 140, 0.4);
}

.btn-register:hover::before {
    left: 100%;
}

.btn-register:active {
    transform: translateY(-1px);
}

.btn-register:disabled {
    opacity: 0.6;
    cursor: not-allowed;
    transform: none !important;
    box-shadow: none !important;
}

/* Иконка на кнопке */
.btn-register::after {
    content: '🚀';
    margin-left: 10px;
    font-weight: bold;
    font-size: 18px;
}

/* Ссылка на вход */
.login-link {
    text-align: center;
    margin-top: 25px;
    padding-top: 25px;
    border-top: 1px solid var(--border-color);
    opacity: 0;
    animation: fadeInLink 0.5s ease-out 0.6s forwards;
}

@keyframes fadeInLink {
    from {
        opacity: 0;
        transform: translateY(10px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.login-link a {
    color: var(--secondary-pink);
    text-decoration: none;
    font-weight: 500;
    font-size: 15px;
    display: inline-flex;
    align-items: center;
    gap: 8px;
    padding: 10px 20px;
    border-radius: 8px;
    transition: all 0.3s ease;
    position: relative;
}

.login-link a::before {
    content: '🔑';
    font-size: 16px;
}

.login-link a::after {
    content: '';
    position: absolute;
    bottom: -2px;
    left: 0;
    width: 0;
    height: 1px;
    background: linear-gradient(90deg, var(--primary-pink), transparent);
    transition: width 0.3s ease;
}

.login-link a:hover {
    color: var(--primary-pink);
    background-color: var(--soft-pink);
}

.login-link a:hover::after {
    width: 100%;
}

/* Индикатор загрузки */
.register-loading {
    display: none;
    text-align: center;
    padding: 20px;
}

.register-loading.active {
    display: block;
}

.loading-spinner-register {
    width: 40px;
    height: 40px;
    border: 3px solid var(--border-color);
    border-top: 3px solid var(--primary-pink);
    border-radius: 50%;
    animation: spinRegister 1s linear infinite;
    margin: 0 auto 15px;
}

@keyframes spinRegister {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

/* Сообщения об ошибках */
.error-message {
    color: #dc3545;
    font-size: 13px;
    margin-top: 5px;
    padding: 8px 12px;
    background-color: rgba(220, 53, 69, 0.1);
    border-radius: 6px;
    border: 1px solid rgba(220, 53, 69, 0.2);
    display: none;
    animation: shakeError 0.5s ease-in-out;
}

@keyframes shakeError {
    0%, 100% { transform: translateX(0); }
    10%, 30%, 50%, 70%, 90% { transform: translateX(-5px); }
    20%, 40%, 60%, 80% { transform: translateX(5px); }
}

.error-message.active {
    display: block;
}

/* Переключатель видимости пароля */
.password-toggle {
    position: absolute;
    right: 15px;
    top: 50%;
    transform: translateY(-50%);
    background: none;
    border: none;
    color: var(--text-secondary);
    cursor: pointer;
    font-size: 18px;
    padding: 0;
    width: 24px;
    height: 24px;
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 2;
}

.password-toggle:hover {
    color: var(--primary-pink);
}

/* Адаптивность */
@media (max-width: 480px) {
    .register-container {
        padding: 30px 20px;
        margin: 0 15px;
    }
    
    .register-title {
        font-size: 28px;
    }
    
    .btn-register {
        padding: 14px 20px;
        font-size: 15px;
    }
    
    .form-input {
        padding: 12px 40px 12px 12px;
    }
    
    .checkbox-group {
        padding: 15px;
    }
}

/* Эффект при успешной регистрации */
@keyframes successPulse {
    0% { box-shadow: 0 0 0 0 rgba(40, 167, 69, 0.4); }
    70% { box-shadow: 0 0 0 10px rgba(40, 167, 69, 0); }
    100% { box-shadow: 0 0 0 0 rgba(40, 167, 69, 0); }
}

.success-pulse {
    animation: successPulse 1s;
}
CSS;

$this->registerCss($css);

// Регистрируем JavaScript для интерактивности
$js = <<< JS
$(document).ready(function() {
    // Создаем переключатели видимости для паролей
    function createPasswordToggles() {
        $('.field-password, .field-password_repeat').each(function() {
            var passwordField = $(this).find('input[type="password"]');
            if (passwordField.length) {
                var toggleButton = $('<button type="button" class="password-toggle">👁️</button>');
                
                passwordField.parent().find('.input-icon').remove();
                passwordField.after(toggleButton);
                
                toggleButton.on('click', function() {
                    var type = passwordField.attr('type');
                    if (type === 'password') {
                        passwordField.attr('type', 'text');
                        toggleButton.html('🔒');
                    } else {
                        passwordField.attr('type', 'password');
                        toggleButton.html('👁️');
                    }
                });
            }
        });
    }
    
    createPasswordToggles();
    
    // Валидация формы
    $('#register-form').on('submit', function(e) {
        var form = $(this);
        var fioField = $('#user-fio');
        var phoneField = $('#user-phone');
        var emailField = $('#user-email');
        var passwordField = $('#user-password');
        var passwordRepeatField = $('#user-password_repeat');
        var agreeCheckbox = $('#user-agree');
        var submitBtn = $('.btn-register');
        var isValid = true;
        
        // Очищаем предыдущие ошибки
        $('.error-message').removeClass('active');
        
        // Валидация ФИО
        if (fioField.val().trim().length < 2) {
            showError(fioField, 'Введите корректное ФИО (минимум 2 символа)');
            isValid = false;
        }
        
        // Валидация телефона
        var phoneValue = phoneField.val().replace(/\D/g, '');
        if (phoneValue.length !== 11) {
            showError(phoneField, 'Введите корректный номер телефона');
            isValid = false;
        }
        
        // Валидация email
        var emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        if (!emailRegex.test(emailField.val())) {
            showError(emailField, 'Введите корректный email адрес');
            isValid = false;
        }
        
        // Валидация пароля
        if (passwordField.val().length < 6) {
            showError(passwordField, 'Пароль должен содержать минимум 6 символов');
            isValid = false;
        }
        
        // Валидация повторного пароля
        if (passwordField.val() !== passwordRepeatField.val()) {
            showError(passwordRepeatField, 'Пароли не совпадают');
            isValid = false;
        }
        
        // Валидация согласия
        if (!agreeCheckbox.is(':checked')) {
            showError(agreeCheckbox, 'Необходимо принять условия пользовательского соглашения');
            isValid = false;
        }
        
        if (!isValid) {
            e.preventDefault();
            
            // Анимация ошибки
            $('.error-message.active').each(function() {
                $(this).css('animation', 'shakeError 0.5s ease-in-out');
                setTimeout(function() {
                    $('.error-message.active').css('animation', '');
                }, 500);
            });
            
            return false;
        }
        
        // Блокируем кнопку и показываем индикатор загрузки
        submitBtn.prop('disabled', true);
        submitBtn.html('<span class="loading-text">Регистрация...</span>');
        
        // Имитация задержки
        setTimeout(function() {
            // В реальном приложении здесь будет отправка формы
            // submitBtn.addClass('success-pulse');
            // setTimeout(function() {
            //     form.submit();
            // }, 1000);
        }, 1500);
        
        return true;
    });
    
    // Функция для показа ошибки
    function showError(field, message) {
        var errorId = field.attr('id') + '-error';
        var errorElement = $('#' + errorId);
        
        if (!errorElement.length) {
            errorElement = $('<div class="error-message" id="' + errorId + '">').text(message);
            field.closest('.form-group').append(errorElement);
        } else {
            errorElement.text(message);
        }
        
        errorElement.addClass('active');
        
        // Подсветка поля с ошибкой
        field.addClass('error-field');
        setTimeout(function() {
            field.removeClass('error-field');
        }, 3000);
    }
    
    // Маска для телефона с кастомным поведением
    $('#user-phone').on('input', function() {
        var value = $(this).val().replace(/\D/g, '');
        
        if (value.length > 0) {
            if (value[0] === '7' || value[0] === '8') {
                value = value.substring(1);
            }
            
            var formatted = '8(';
            
            if (value.length > 0) {
                formatted += value.substring(0, 3);
            }
            if (value.length > 3) {
                formatted += ')' + value.substring(3, 6);
            }
            if (value.length > 6) {
                formatted += '-' + value.substring(6, 8);
            }
            if (value.length > 8) {
                formatted += '-' + value.substring(8, 10);
            }
            
            $(this).val(formatted);
        }
    });
    
    // Стиль для поля с ошибкой
    $('<style>')
        .text('.error-field { border-color: #dc3545 !important; box-shadow: 0 0 0 3px rgba(220, 53, 69, 0.2) !important; }')
        .appendTo('head');
    
    // Автофокус на поле ФИО
    setTimeout(function() {
        $('#user-fio').focus();
    }, 500);
    
    // Анимация появления дополнительных элементов
    setTimeout(function() {
        $('.login-link').css({
            'opacity': '0',
            'transform': 'translateY(10px)',
            'animation': 'fadeInLink 0.5s ease-out forwards',
            'animation-delay': '0.7s'
        });
    }, 300);
});
JS;

$this->registerJs($js, View::POS_READY);

$form = ActiveForm::begin([
    'id' => 'register-form',
    'enableClientValidation' => true,
    'options' => ['class' => 'register-form']
]);
?>

    <div class="register-container">
        <div class="register-header">
            <h1 class="register-title">Регистрация аккаунта</h1>
            <p class="register-subtitle">Создайте свой аккаунт для доступа к играм</p>
        </div>

        <div class="register-form-wrapper">
            <?= $form->field($model, 'fio', [
                'template' => '<div class="form-group field-fio">{label}<div class="input-wrapper">{input}<span class="input-icon"></span></div>{error}</div>',
                'labelOptions' => ['class' => 'form-label'],
                'errorOptions' => ['class' => 'help-block error-message']
            ])->textInput([
                'class' => 'form-input',
                'id' => 'user-fio',
                'placeholder' => 'Иванов Иван Иванович',
                'autocomplete' => 'name'
            ]) ?>

            <?= $form->field($model, 'phone', [
                'template' => '<div class="form-group field-phone">{label}<div class="input-wrapper">{input}<span class="input-icon"></span></div>{error}</div>',
                'labelOptions' => ['class' => 'form-label'],
                'errorOptions' => ['class' => 'help-block error-message']
            ])->widget(MaskedInput::class, [
                'mask' => '8(999)999-99-99',
                'options' => [
                    'class' => 'form-input',
                    'id' => 'user-phone',
                    'placeholder' => '8(999)123-45-67',
                    'autocomplete' => 'tel'
                ]
            ]) ?>

            <?= $form->field($model, 'email', [
                'template' => '<div class="form-group field-email">{label}<div class="input-wrapper">{input}<span class="input-icon"></span></div>{error}</div>',
                'labelOptions' => ['class' => 'form-label'],
                'errorOptions' => ['class' => 'help-block error-message']
            ])->textInput([
                'class' => 'form-input',
                'id' => 'user-email',
                'placeholder' => 'example@mail.ru',
                'type' => 'email',
                'autocomplete' => 'email'
            ]) ?>

            <?= $form->field($model, 'password', [
                'template' => '<div class="form-group field-password">{label}<div class="input-wrapper">{input}<span class="input-icon"></span></div>{error}</div>',
                'labelOptions' => ['class' => 'form-label'],
                'errorOptions' => ['class' => 'help-block error-message']
            ])->passwordInput([
                'class' => 'form-input',
                'id' => 'user-password',
                'placeholder' => 'Придумайте надежный пароль',
                'autocomplete' => 'new-password'
            ]) ?>

            <?= $form->field($model, 'password_repeat', [
                'template' => '<div class="form-group field-password_repeat">{label}<div class="input-wrapper">{input}<span class="input-icon"></span></div>{error}</div>',
                'labelOptions' => ['class' => 'form-label'],
                'errorOptions' => ['class' => 'help-block error-message']
            ])->passwordInput([
                'class' => 'form-input',
                'id' => 'user-password_repeat',
                'placeholder' => 'Повторите пароль',
                'autocomplete' => 'new-password'
            ]) ?>

            <div class="checkbox-group">
                <label class="custom-checkbox">
                    <?= $form->field($model, 'agree', [
                        'template' => '{input}',
                        'options' => ['tag' => false]
                    ])->checkbox([
                        'class' => 'checkbox-input',
                        'id' => 'user-agree',
                        'uncheck' => null
                    ], false) ?>
                    <span class="checkbox-box"></span>
                    <span class="checkbox-label">
                    Я принимаю <a href="/terms" target="_blank">условия пользовательского соглашения</a> и даю согласие на обработку персональных данных
                </span>
                </label>
            </div>

            <button type="submit" class="btn-register">Создать аккаунт</button>

            <div class="login-link">
                <?= Html::a('Уже есть аккаунт? Войти', ['/site/login'], [
                    'class' => 'login-link-text'
                ]) ?>
            </div>
        </div>

        <!-- Индикатор загрузки -->
        <div class="register-loading">
            <div class="loading-spinner-register"></div>
            <p style="color: var(--text-secondary); margin-top: 10px;">Создаем ваш аккаунт...</p>
        </div>
    </div>

<?php ActiveForm::end(); ?>