<?php
use yii\widgets\ActiveForm;
use yii\helpers\Html;
use yii\web\View;

/* @var $model app\models\Request */
/* @var $user app\models\User */
/* @var $game app\models\GameSchedule */

// Регистрируем CSS стили
$css = <<< CSS
/* Основные цвета */
:root {
    --primary-black: #121212;
    --secondary-black: #1a1a1a;
    --dark-gray: #2d2d2d;
    --light-gray: #444;
    --primary-pink: #e83e8c;
    --secondary-pink: #ff6b9d;
    --soft-pink: rgba(232, 62, 140, 0.1);
    --text-primary: #f8f9fa;
    --text-secondary: #b0b0b0;
    --border-color: #333;
    --hover-black: #252525;
    --success-color: #28a745;
}

/* Контейнер формы */
.booking-container {
    background-color: var(--primary-black);
    border-radius: 16px;
    padding: 30px;
    box-shadow: 0 15px 35px rgba(0, 0, 0, 0.5);
    border: 1px solid var(--border-color);
    margin-bottom: 30px;
    position: relative;
    overflow: hidden;
    max-width: 800px;
    margin: 0 auto;
}

.booking-container::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 4px;
    background: linear-gradient(90deg, var(--primary-pink), var(--secondary-pink));
    z-index: 10;
}

.booking-container::after {
    content: '';
    position: absolute;
    top: -50%;
    left: -50%;
    width: 200%;
    height: 200%;
    background: radial-gradient(circle, rgba(232, 62, 140, 0.05) 0%, rgba(232, 62, 140, 0) 70%);
    z-index: 0;
    pointer-events: none;
}

/* Заголовок */
.booking-header {
    color: var(--text-primary);
    font-size: 32px;
    margin-bottom: 30px;
    padding-bottom: 20px;
    border-bottom: 1px solid var(--border-color);
    position: relative;
    font-weight: 600;
    text-align: center;
    z-index: 1;
}

.booking-header::after {
    content: '';
    position: absolute;
    bottom: -1px;
    left: 50%;
    transform: translateX(-50%);
    width: 150px;
    height: 2px;
    background: linear-gradient(90deg, transparent, var(--primary-pink), transparent);
}

/* Анимация появления формы */
@keyframes fadeInForm {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.booking-form {
    animation: fadeInForm 0.8s ease-out forwards;
    position: relative;
    z-index: 1;
}

/* Информация об игре */
.game-info-section {
    background-color: var(--secondary-black);
    border-radius: 12px;
    padding: 25px;
    margin-bottom: 30px;
    border: 1px solid var(--border-color);
    position: relative;
    overflow: hidden;
}

.game-info-section::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 6px;
    height: 100%;
    background: linear-gradient(to bottom, var(--primary-pink), var(--secondary-pink));
}

.game-info-title {
    color: var(--text-primary);
    font-size: 20px;
    margin-bottom: 20px;
    font-weight: 600;
    display: flex;
    align-items: center;
    gap: 10px;
}

.game-info-title::before {
    content: '🎮';
    font-size: 24px;
}

.game-info-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
    gap: 15px;
}

.game-info-item {
    display: flex;
    flex-direction: column;
}

.game-info-label {
    color: var(--text-secondary);
    font-size: 14px;
    margin-bottom: 5px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.game-info-value {
    color: var(--text-primary);
    font-size: 16px;
    font-weight: 500;
    padding: 10px 15px;
    background-color: var(--dark-gray);
    border-radius: 8px;
    border: 1px solid var(--border-color);
    min-height: 44px;
    display: flex;
    align-items: center;
}

.game-price-value {
    color: var(--secondary-pink);
    font-weight: 600;
    font-size: 18px;
}

/* Поля формы */
.form-group {
    margin-bottom: 25px;
}

.form-group label {
    color: var(--text-primary);
    font-weight: 500;
    margin-bottom: 8px;
    display: block;
    font-size: 15px;
}

.form-control {
    background-color: var(--dark-gray);
    border: 1px solid var(--border-color);
    color: var(--text-primary);
    border-radius: 8px;
    padding: 12px 15px;
    font-size: 15px;
    transition: all 0.3s ease;
    width: 100%;
}

.form-control:focus {
    border-color: var(--primary-pink);
    box-shadow: 0 0 0 3px rgba(232, 62, 140, 0.2);
    outline: none;
    background-color: var(--light-gray);
}

.form-control:read-only {
    background-color: var(--secondary-black);
    opacity: 0.8;
}

/* Стили для select */
select.form-control {
    appearance: none;
    background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='16' height='16' fill='%23e83e8c' viewBox='0 0 16 16'%3E%3Cpath d='M7.247 11.14 2.451 5.658C1.885 5.013 2.345 4 3.204 4h9.592a1 1 0 0 1 .753 1.659l-4.796 5.48a1 1 0 0 1-1.506 0z'/%3E%3C/svg%3E");
    background-repeat: no-repeat;
    background-position: right 15px center;
    background-size: 16px;
    padding-right: 40px;
}

/* Чекбокс */
.checkbox-wrapper {
    display: flex;
    align-items: flex-start;
    gap: 12px;
    padding: 15px;
    background-color: var(--secondary-black);
    border-radius: 8px;
    border: 1px solid var(--border-color);
    margin: 25px 0;
    transition: all 0.3s ease;
}

.checkbox-wrapper:hover {
    background-color: var(--hover-black);
    border-color: var(--primary-pink);
}

.checkbox-wrapper input[type="checkbox"] {
    width: 20px;
    height: 20px;
    margin-top: 2px;
    appearance: none;
    background-color: var(--dark-gray);
    border: 2px solid var(--border-color);
    border-radius: 4px;
    cursor: pointer;
    position: relative;
    transition: all 0.3s ease;
    flex-shrink: 0;
}

.checkbox-wrapper input[type="checkbox"]:checked {
    background-color: var(--primary-pink);
    border-color: var(--primary-pink);
}

.checkbox-wrapper input[type="checkbox"]:checked::after {
    content: '✓';
    position: absolute;
    color: white;
    font-size: 14px;
    font-weight: bold;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
}

.checkbox-wrapper label {
    margin-bottom: 0;
    color: var(--text-primary);
    cursor: pointer;
    line-height: 1.5;
}

/* Кнопка отправки */
.btn-submit {
    background: linear-gradient(135deg, var(--primary-pink), var(--secondary-pink));
    color: white;
    border: none;
    border-radius: 10px;
    padding: 16px 30px;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 1px;
    font-size: 16px;
    transition: all 0.4s ease;
    box-shadow: 0 6px 20px rgba(232, 62, 140, 0.3);
    position: relative;
    overflow: hidden;
    display: block;
    width: 100%;
    margin-top: 20px;
    cursor: pointer;
}

.btn-submit::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
    transition: left 0.7s ease;
}

.btn-submit:hover {
    transform: translateY(-3px);
    box-shadow: 0 12px 25px rgba(232, 62, 140, 0.4);
}

.btn-submit:hover::before {
    left: 100%;
}

.btn-submit:active {
    transform: translateY(-1px);
}

/* Анимация элементов формы */
@keyframes fadeInItem {
    from {
        opacity: 0;
        transform: translateX(-10px);
    }
    to {
        opacity: 1;
        transform: translateX(0);
    }
}

.form-group, .checkbox-wrapper, .game-info-section {
    opacity: 0;
    animation: fadeInItem 0.5s ease-out forwards;
}

/* Индикатор загрузки */
.loading-overlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(18, 18, 18, 0.9);
    display: flex;
    justify-content: center;
    align-items: center;
    z-index: 1000;
    opacity: 0;
    visibility: hidden;
    transition: all 0.3s ease;
}

.loading-overlay.active {
    opacity: 1;
    visibility: visible;
}

.loading-spinner {
    width: 60px;
    height: 60px;
    border: 4px solid var(--border-color);
    border-top: 4px solid var(--primary-pink);
    border-radius: 50%;
    animation: spin 1s linear infinite;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

/* Адаптивность */
@media (max-width: 768px) {
    .booking-container {
        padding: 20px;
        margin: 0 15px;
    }
    
    .booking-header {
        font-size: 26px;
    }
    
    .game-info-grid {
        grid-template-columns: 1fr;
    }
    
    .btn-submit {
        padding: 14px 20px;
        font-size: 15px;
    }
}
/* Цвет текста в select */
select.form-control {
    color: #f8f9fa; /* белый текст */
}

/* Цвет пунктов в выпадающем списке */
select.form-control option {
    background-color: #2d2d2d; /* тёмный фон */
    color: #f8f9fa;            /* белый текст */
}

@media (max-width: 480px) {
    .booking-container {
        padding: 15px;
    }
    
    .game-info-section {
        padding: 15px;
    }
    
    .booking-header {
        font-size: 22px;
    }
}
CSS;

$this->registerCss($css);

// Регистрируем JavaScript для анимаций
$js = <<< JS
$(document).ready(function() {
    // Анимация элементов формы с задержкой
    $('.form-group, .checkbox-wrapper, .game-info-section').each(function(index) {
        $(this).css('animation-delay', (index * 0.1) + 's');
    });
    
    // Анимация кнопки при наведении
    $('.btn-submit').on('mouseenter', function() {
        $(this).addClass('hover-effect');
    });
    
    // Обработка отправки формы с индикатором загрузки
    $('form').on('submit', function(e) {
        var form = $(this);
        var isValid = true;
        
        // Проверка обязательных полей
        form.find('input[required], select[required]').each(function() {
            if (!$(this).val()) {
                $(this).addClass('error-field');
                isValid = false;
            } else {
                $(this).removeClass('error-field');
            }
        });
        
        // Проверка чекбокса согласия
        if (!form.find('#request-agree').is(':checked')) {
            $('.checkbox-wrapper').addClass('error-field');
            isValid = false;
        } else {
            $('.checkbox-wrapper').removeClass('error-field');
        }
        
        if (isValid) {
            // Показываем индикатор загрузки
            $('.loading-overlay').addClass('active');
            
            // Эффект отправки формы
            setTimeout(function() {
                $('.loading-overlay').removeClass('active');
            }, 2000);
            
            return true;
        } else {
            // Анимация ошибки
            $('.error-field').each(function() {
                $(this).css('animation', 'shake 0.5s ease-in-out');
                setTimeout(function() {
                    $('.error-field').css('animation', '');
                }, 500);
            });
            
            e.preventDefault();
            return false;
        }
    });
    
    // Добавляем стиль для поля с ошибкой
    $('<style>')
        .text('.error-field { border-color: #dc3545 !important; box-shadow: 0 0 0 3px rgba(220, 53, 69, 0.2) !important; }')
        .text('@keyframes shake { 0%, 100% { transform: translateX(0); } 10%, 30%, 50%, 70%, 90% { transform: translateX(-5px); } 20%, 40%, 60%, 80% { transform: translateX(5px); } }')
        .appendTo('head');
});
JS;

$this->registerJs($js, View::POS_READY);
?>

<div class="booking-container">
    <h1 class="booking-header">Запись на игру</h1>

    <div class="booking-form">
        <?php $form = ActiveForm::begin([
            'id' => 'booking-form',
            'enableClientValidation' => true,
        ]); ?>

        <?= Html::activeHiddenInput($model, 'game_schedule_id', ['value' => $game->id]) ?>
        <?= Html::activeHiddenInput($model, 'game_type', ['value' => $game->game_type]) ?>
        <?= Html::activeHiddenInput($model, 'game_name', ['value' => $game->game_name]) ?>
        <?= Html::activeHiddenInput($model, 'game_date', ['value' => $game->game_date]) ?>
        <?= Html::activeHiddenInput($model, 'game_time', ['value' => $game->game_time]) ?>
        <?= Html::activeHiddenInput($model, 'address', ['value' => $game->address]) ?>
        <?= Html::activeHiddenInput($model, 'price', ['value' => $game->price]) ?>
        <?= $form->field($model, 'game_id')->hiddenInput(['value' => $game->id])->label(false) ?>

        <!-- Информация об игре -->
        <div class="game-info-section">
            <div class="game-info-title">Информация об игре</div>
            <div class="game-info-grid">
                <div class="game-info-item">
                    <div class="game-info-label">Вид игры</div>
                    <div class="game-info-value"><?= Html::encode($game->game_type) ?></div>
                </div>
                <div class="game-info-item">
                    <div class="game-info-label">Название игры</div>
                    <div class="game-info-value"><?= Html::encode($game->game_name) ?></div>
                </div>
                <div class="game-info-item">
                    <div class="game-info-label">Дата игры</div>
                    <div class="game-info-value"><?= Html::encode($game->game_date) ?></div>
                </div>
                <div class="game-info-item">
                    <div class="game-info-label">Время игры</div>
                    <div class="game-info-value"><?= Html::encode($game->game_time) ?></div>
                </div>
                <div class="game-info-item">
                    <div class="game-info-label">Адрес</div>
                    <div class="game-info-value"><?= Html::encode($game->address) ?></div>
                </div>
                <div class="game-info-item">
                    <div class="game-info-label">Цена</div>
                    <div class="game-info-value game-price-value"><?= Html::encode($game->price) ?> ₽</div>
                </div>
            </div>
        </div>

        <!-- Поля для выбора -->
        <div class="form-group">
            <?= $form->field($model, 'payment_method')
                ->dropDownList([
                    'наличные' => 'Наличные',
                    'карта' => 'Карта',
                    'перевод' => 'Перевод'
                ], [
                    'prompt' => 'Выберите способ оплаты',
                    'class' => 'form-control'
                ])->label('Способ оплаты') ?>
        </div>

        <div class="form-group">
            <?= $form->field($model, 'player_status')
                ->dropDownList([
                    'новичок' => 'Новичок',
                    'любитель' => 'Любитель',
                    'профессионал' => 'Профессионал'
                ], [
                    'prompt' => 'Выберите ваш уровень',
                    'class' => 'form-control'
                ])->label('Ваш уровень игры') ?>
        </div>

        <!-- Чекбокс согласия -->
        <?= $form->field($model, 'agree', [
            'template' => '<div class="checkbox-wrapper">{input}{label}{error}</div>',
            'labelOptions' => ['class' => null]
        ])->checkbox([
            'label' => 'Я согласен на обработку персональных данных',
            'uncheck' => null
        ]) ?>

        <!-- Кнопка отправки -->
        <?= Html::submitButton('Забронировать место', [
            'class' => 'btn-submit',
            'id' => 'submit-button'
        ]) ?>

        <?php ActiveForm::end(); ?>
    </div>
</div>

<!-- Индикатор загрузки -->
<div class="loading-overlay">
    <div class="loading-spinner"></div>
</div>