<?php

/** @var yii\web\View $this */
/** @var string $content */

use app\assets\AppAsset;
use app\widgets\Alert;
use yii\bootstrap5\Breadcrumbs;
use yii\bootstrap5\Html;
use yii\bootstrap5\Nav;
use yii\bootstrap5\NavBar;
use yii\web\View;

AppAsset::register($this);

$this->registerCsrfMetaTags();
$this->registerMetaTag(['charset' => Yii::$app->charset], 'charset');
$this->registerMetaTag(['name' => 'viewport', 'content' => 'width=device-width, initial-scale=1, shrink-to-fit=no']);
$this->registerMetaTag(['name' => 'description', 'content' => $this->params['meta_description'] ?? '']);
$this->registerMetaTag(['name' => 'keywords', 'content' => $this->params['meta_keywords'] ?? '']);
$this->registerLinkTag(['rel' => 'icon', 'type' => 'image/x-icon', 'href' => Yii::getAlias('@web/favicon.ico')]);

// Регистрируем CSS стили для макета
$css = <<< CSS
/* Основные цвета */
:root {
    --primary-black: #121212;
    --secondary-black: #1a1a1a;
    --dark-gray: #2d2d2d;
    --light-gray: #444;
    --primary-pink: #e83e8c;
    --secondary-pink: #ff6b9d;
    --soft-pink: rgba(232, 62, 140, 0.1);
    --text-primary: #f8f9fa;
    --text-secondary: #b0b0b0;
    --border-color: #333;
    --hover-black: #252525;
    --success-color: #28a745;
    --warning-color: #ffc107;
    --danger-color: #dc3545;
    --info-color: #17a2b8;
}

/* Общие стили */
html, body {
    height: 100%;
    background-color: var(--primary-black);
    color: var(--text-primary);
    font-family: 'Segoe UI', system-ui, -apple-system, sans-serif;
    line-height: 1.6;
}

body {
    background: linear-gradient(135deg, #0a0a0a 0%, #121212 50%, #1a1a1a 100%);
    min-height: 100vh;
    position: relative;
}

body::before {
    content: '';
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: 
        radial-gradient(circle at 20% 30%, rgba(232, 62, 140, 0.05) 0%, transparent 50%),
        radial-gradient(circle at 80% 70%, rgba(255, 107, 157, 0.03) 0%, transparent 50%);
    z-index: -1;
    pointer-events: none;
}

/* Навбар */
.navbar-custom {
    background: linear-gradient(135deg, var(--secondary-black), var(--primary-black)) !important;
    border-bottom: 1px solid var(--border-color);
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.3);
    padding: 0.8rem 0;
    position: fixed;
    top: 0;
    width: 100%;
    z-index: 1000;
}

.navbar-custom::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 2px;
    background: linear-gradient(90deg, var(--primary-pink), var(--secondary-pink));
}

.navbar-brand {
    color: var(--text-primary) !important;
    font-size: 24px;
    font-weight: 700;
    padding: 10px 20px;
    border-radius: 8px;
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
    display: flex;
    align-items: center;
    gap: 10px;
}

.navbar-brand::before {
    content: '🎮';
    font-size: 20px;
}

.navbar-brand::after {
    content: '';
    position: absolute;
    bottom: 0;
    left: 0;
    width: 0;
    height: 2px;
    background: linear-gradient(90deg, var(--primary-pink), transparent);
    transition: width 0.3s ease;
}

.navbar-brand:hover {
    color: var(--primary-pink) !important;
    transform: translateY(-2px);
}

.navbar-brand:hover::after {
    width: 100%;
}

/* Навигационные ссылки */
.nav-link-custom {
    color: var(--text-secondary) !important;
    font-weight: 500;
    padding: 10px 20px !important;
    margin: 0 5px;
    border-radius: 8px;
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
    display: flex;
    align-items: center;
    gap: 8px;
}

.nav-link-custom::before {
    content: '';
    position: absolute;
    left: 0;
    bottom: 0;
    width: 0;
    height: 2px;
    background: linear-gradient(90deg, var(--primary-pink), transparent);
    transition: width 0.3s ease;
}

.nav-link-custom:hover {
    color: var(--text-primary) !important;
    background-color: var(--soft-pink);
    transform: translateY(-2px);
}

.nav-link-custom:hover::before {
    width: 100%;
}

.nav-link-custom.active {
    color: var(--primary-pink) !important;
    background-color: var(--soft-pink);
}

.nav-link-custom.active::before {
    width: 100%;
}

/* Иконки для пунктов меню */
.nav-link-custom[href*="index"]::before { content: '🏠'; }
.nav-link-custom[href*="register"]::before { content: '📝'; }
.nav-link-custom[href*="login"]::before { content: '🔐'; }
.nav-link-custom[href*="requests"]::before { content: '📋'; }
.nav-link-custom[href*="games"]::before { content: '🎯'; }
.nav-link-custom[href*="admin"]::before { content: '⚙️'; }

/* Кнопка выхода */
.logout-form {
    display: inline-block;
}

.logout-btn {
    background: linear-gradient(135deg, #dc3545, #e35d6a) !important;
    color: white !important;
    border: none;
    border-radius: 8px;
    padding: 10px 20px !important;
    font-weight: 600;
    transition: all 0.3s ease;
    cursor: pointer;
    margin-left: 10px;
    box-shadow: 0 4px 12px rgba(220, 53, 69, 0.3);
    position: relative;
    overflow: hidden;
}

.logout-btn::before {
    content: '🚪';
    margin-right: 8px;
}

.logout-btn::after {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
    transition: left 0.7s ease;
}

.logout-btn:hover {
    transform: translateY(-3px);
    box-shadow: 0 8px 20px rgba(220, 53, 69, 0.4);
}

.logout-btn:hover::after {
    left: 100%;
}

/* Главный контейнер */
#main {
    margin-top: 80px;
    min-height: calc(100vh - 180px);
}

.container {
    max-width: 1200px;
    padding: 0 20px;
}

/* Хлебные крошки */
.breadcrumb {
    background-color: var(--secondary-black);
    border-radius: 10px;
    padding: 15px 20px;
    margin-bottom: 30px;
    border: 1px solid var(--border-color);
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
}

.breadcrumb-item {
    color: var(--text-secondary);
}

.breadcrumb-item a {
    color: var(--primary-pink);
    text-decoration: none;
    transition: all 0.3s ease;
    position: relative;
    padding: 5px 10px;
    border-radius: 5px;
}

.breadcrumb-item a:hover {
    color: var(--secondary-pink);
    background-color: var(--soft-pink);
}

.breadcrumb-item.active {
    color: var(--text-primary);
}

.breadcrumb-item + .breadcrumb-item::before {
    color: var(--text-secondary);
    content: "›";
    padding: 0 10px;
}

/* Подвал */
.footer-custom {
    background: linear-gradient(135deg, var(--secondary-black), var(--primary-black)) !important;
    border-top: 1px solid var(--border-color);
    margin-top: auto;
    padding: 2rem 0 !important;
    color: var(--text-secondary) !important;
    position: relative;
}

.footer-custom::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 1px;
    background: linear-gradient(90deg, transparent, var(--primary-pink), transparent);
}

.footer-custom a {
    color: var(--primary-pink);
    text-decoration: none;
    transition: all 0.3s ease;
}

.footer-custom a:hover {
    color: var(--secondary-pink);
    text-decoration: underline;
}

/* Анимации */
@keyframes fadeIn {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

#main > .container {
    animation: fadeIn 0.8s ease-out;
}

/* Мобильная адаптивность */
@media (max-width: 991.98px) {
    .navbar-nav {
        background: var(--secondary-black);
        border-radius: 10px;
        padding: 15px;
        margin-top: 10px;
        border: 1px solid var(--border-color);
    }
    
    .nav-link-custom {
        margin: 5px 0;
    }
    
    .logout-btn {
        margin: 10px 0 0 0;
        width: 100%;
        text-align: left;
    }
}

@media (max-width: 767.98px) {
    .navbar-brand {
        font-size: 20px;
        padding: 8px 15px;
    }
    
    #main {
        margin-top: 70px;
    }
    
    .container {
        padding: 0 15px;
    }
    
    .breadcrumb {
        padding: 10px 15px;
        font-size: 14px;
    }
}

/* Эффект стеклянного морфизма для меню */
.navbar-collapse {
    backdrop-filter: blur(10px);
    background-color: rgba(26, 26, 26, 0.95);
}

/* Плавная прокрутка */
html {
    scroll-behavior: smooth;
}

/* Кастомный скроллбар */
::-webkit-scrollbar {
    width: 10px;
}

::-webkit-scrollbar-track {
    background: var(--secondary-black);
}

::-webkit-scrollbar-thumb {
    background: linear-gradient(135deg, var(--primary-pink), var(--secondary-pink));
    border-radius: 5px;
}

::-webkit-scrollbar-thumb:hover {
    background: linear-gradient(135deg, var(--secondary-pink), var(--primary-pink));
}
/* Стили для футера */
.footer-custom {
    background: linear-gradient(135deg, var(--secondary-black), var(--primary-black)) !important;
    border-top: 1px solid var(--border-color);
    margin-top: auto;
    padding: 3rem 0 2rem !important;
    color: var(--text-secondary) !important;
    position: relative;
}

.footer-custom::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 1px;
    background: linear-gradient(90deg, transparent, var(--primary-pink), transparent);
}

.footer-brand h3 {
    font-size: 24px;
    background: linear-gradient(135deg, var(--primary-pink), var(--secondary-pink));
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

/* Социальные иконки */
.social-icons {
    margin-top: 20px;
}

.social-icon {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    width: 40px;
    height: 40px;
    background: var(--dark-gray);
    border-radius: 50%;
    color: var(--text-secondary);
    transition: all 0.3s ease;
    text-decoration: none;
}

.social-icon:hover {
    background: linear-gradient(135deg, var(--primary-pink), var(--secondary-pink));
    color: white;
    transform: translateY(-3px);
    box-shadow: 0 5px 15px rgba(232, 62, 140, 0.3);
}

/* Меню в футере */
.footer-menu h5 {
    font-size: 18px;
    margin-bottom: 20px;
    position: relative;
    padding-bottom: 10px;
}

.footer-menu h5::after {
    content: '';
    position: absolute;
    bottom: 0;
    left: 0;
    width: 40px;
    height: 2px;
    background: linear-gradient(90deg, var(--primary-pink), transparent);
}

.footer-link {
    color: var(--text-secondary) !important;
    text-decoration: none;
    transition: all 0.3s ease;
    display: inline-flex;
    align-items: center;
    gap: 10px;
    padding: 5px 0;
    position: relative;
}

.footer-link::before {
    content: '';
    position: absolute;
    left: 0;
    bottom: 0;
    width: 0;
    height: 1px;
    background: var(--primary-pink);
    transition: width 0.3s ease;
}

.footer-link:hover {
    color: var(--primary-pink) !important;
    transform: translateX(5px);
}

.footer-link:hover::before {
    width: 20px;
}

/* Адаптивность футера */
@media (max-width: 767.98px) {
    .footer-custom {
        padding: 2rem 0 1.5rem !important;
    }
    
    .footer-menu {
        margin-bottom: 20px;
    }
    
    .social-icons {
        justify-content: center;
    }
}
CSS;

$this->registerCss($css);

// Регистрируем JavaScript для интерактивности навбара
$js = <<< 'JS'
$(document).ready(function() {
    // Анимация навбара при прокрутке
    $(window).scroll(function() {
        var scroll = $(window).scrollTop();
        if (scroll > 100) {
            $('.navbar-custom').addClass('navbar-scrolled');
        } else {
            $('.navbar-custom').removeClass('navbar-scrolled');
        }
    });
    
    // Добавляем активный класс текущему пункту меню
    var currentUrl = window.location.pathname;
    $('.nav-link-custom').each(function() {
        var linkUrl = $(this).attr('href');
        if (linkUrl && currentUrl.indexOf(linkUrl) !== -1) {
            $(this).addClass('active');
        }
    });
    
    // Анимация для логотипа
    $('.navbar-brand').on('mouseenter', function() {
        $(this).css('transform', 'translateY(-3px) scale(1.05)');
    }).on('mouseleave', function() {
        $(this).css('transform', 'translateY(0) scale(1)');
    });
    
    // Плавное появление контента
    setTimeout(function() {
        $('.container').addClass('loaded');
    }, 300);
    
    // Добавляем стиль для скроллинг навбара
    $('<style>')
        .text('.navbar-scrolled { padding: 0.5rem 0 !important; box-shadow: 0 8px 25px rgba(0, 0, 0, 0.5) !important; }')
        .appendTo('head');
});
JS;

$this->registerJs($js, View::POS_READY);
?>
<?php $this->beginPage() ?>
    <!DOCTYPE html>
    <html lang="<?= Yii::$app->language ?>" class="h-100">
    <head>
        <meta charset="<?= Yii::$app->charset ?>">
        <title><?= Html::encode($this->title) ?></title>
        <?php $this->head() ?>
    </head>
    <body class="d-flex flex-column h-100">
    <?php $this->beginBody() ?>

    <header id="header">
        <?php
        NavBar::begin([
            'brandLabel' => 'Настольные игры',
            'brandUrl' => Yii::$app->homeUrl,
            'options' => ['class' => 'navbar-expand-lg navbar-custom fixed-top'],
            'containerOptions' => ['class' => 'container-fluid'],
            'collapseOptions' => ['class' => 'justify-content-end']
        ]);

        $menuItems = [];

        /* ---------- ОБЩЕЕ ---------- */
        $menuItems[] = ['label' => 'Главная', 'url' => ['/site/index'], 'linkOptions' => ['class' => 'nav-link-custom']];

        /* ---------- ГОСТЬ ---------- */
        if (Yii::$app->user->isGuest) {
            $menuItems[] = ['label' => 'Регистрация', 'url' => ['/site/register'], 'linkOptions' => ['class' => 'nav-link-custom']];
            $menuItems[] = ['label' => 'Авторизация', 'url' => ['/site/login'], 'linkOptions' => ['class' => 'nav-link-custom']];
        } else {
            /* ---------- АВТОРИЗОВАН ---------- */
            $menuItems[] = ['label' => 'Мои заявки', 'url' => ['/site/requests'], 'linkOptions' => ['class' => 'nav-link-custom']];
            $menuItems[] = ['label' => 'Игры', 'url' => ['/site/games'], 'linkOptions' => ['class' => 'nav-link-custom']];

            /* ---------- АДМИН ---------- */
            if (Yii::$app->user->identity->isAdmin()) {
                $menuItems[] = ['label' => 'Админ-панель', 'url' => ['/admin/index'], 'linkOptions' => ['class' => 'nav-link-custom']];
            }

            $menuItems[] = '<li class="nav-item">'
                . Html::beginForm(['/site/logout'], 'post', ['class' => 'logout-form'])
                . Html::submitButton(
                    'Выход',
                    ['class' => 'nav-link-custom logout-btn']
                )
                . Html::endForm()
                . '</li>';
        }

        echo Nav::widget([
            'options' => ['class' => 'navbar-nav ms-auto align-items-center'],
            'items' => $menuItems,
            'encodeLabels' => false,
        ]);

        NavBar::end();
        ?>
    </header>

    <main id="main" class="flex-shrink-0" role="main">
        <div class="container">
            <?php if (!empty($this->params['breadcrumbs'])): ?>
                <?= Breadcrumbs::widget([
                    'links' => $this->params['breadcrumbs'],
                    'options' => ['class' => 'breadcrumb'],
                    'itemTemplate' => "<li class='breadcrumb-item'>{link}</li>\n",
                    'activeItemTemplate' => "<li class='breadcrumb-item active'>{link}</li>\n"
                ]) ?>
            <?php endif ?>
            <?= Alert::widget() ?>
            <?= $content ?>
        </div>
    </main>

    <footer id="footer" class="mt-auto py-5 footer-custom">
        <div class="container">
            <div class="row">
                <!-- Колонка с логотипом и описанием -->
                <div class="col-lg-4 col-md-6 mb-4">
                    <div class="footer-brand">
                        <h3 class="fw-bold mb-3" style="color: var(--primary-pink);">
                            🎮 Настольные игры
                        </h3>
                        <p class="text-secondary mb-4">
                            Платформа для организации игровых вечеров.
                            Присоединяйтесь к сообществу любителей настольных игр!
                        </p>
                        <div class="social-icons d-flex gap-3">
                            <a href="#" class="social-icon" title="VK">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M15.07 2H8.93C3.33 2 2 3.33 2 8.93V15.07C2 20.67 3.33 22 8.93 22H15.07C20.67 22 22 20.67 22 15.07V8.93C22 3.33 20.67 2 15.07 2M18.15 16.27H16.69C16.14 16.27 15.97 15.82 15 14.83C14.12 13.94 13.94 13.94 13.84 13.94C13.64 13.94 13.56 14.03 13.56 14.41V15.69C13.56 16.04 13.5 16.26 12.83 16.26C11.82 16.26 10.86 15.75 9.97 14.83C8.58 13.4 7.83 11.61 7.83 9.57C7.83 9.23 7.83 8.85 8.21 8.85H9.66C10.03 8.85 10.18 9.03 10.31 9.36C10.81 10.56 11.42 11.73 12 12.71C12.17 12.99 12.4 13.22 12.66 13.22C12.78 13.22 12.86 13.18 12.86 12.82V10.5C12.86 9.72 12.79 9.56 12.24 9.56C11.42 9.56 10.55 10.18 9.63 11.34L9.55 11.45L9.44 11.31C10.2 10.29 10.94 9.58 11.64 9.18C12.34 8.78 13 8.64 13.62 8.64C14.33 8.64 14.62 8.97 14.62 9.72V12.66C14.62 13.13 14.71 13.22 15.03 13.22C15.25 13.22 15.44 13.11 15.65 12.92C16.16 12.43 16.63 11.77 17.08 10.99C17.26 10.68 17.41 10.41 17.57 10.41H19C19.37 10.41 19.5 10.65 19.5 11.05C19.5 11.64 19.05 12.65 18.15 13.87C17.32 15.01 16.5 15.65 15.78 15.97C15.5 16.09 15.34 16.27 15.5 16.61C15.78 17.26 16.44 18.28 16.84 18.74C17.24 19.2 17.6 19.54 18.04 19.54H19.43C19.8 19.54 20 19.34 20 18.96C20 18.4 19.5 17.46 18.95 16.79C18.57 16.31 18.36 16.27 18.15 16.27Z"/>
                                </svg>
                            </a>
                            <a href="#" class="social-icon" title="Telegram">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M12 2C6.48 2 2 6.48 2 12C2 17.52 6.48 22 12 22C17.52 22 22 17.52 22 12C22 6.48 17.52 2 12 2ZM16.64 8.8C16.49 10.38 15.84 14.22 15.51 15.99C15.37 16.74 15.09 16.99 14.83 17.02C14.25 17.07 13.81 16.64 13.25 16.27C12.37 15.69 11.87 15.33 11.02 14.77C10.03 14.12 10.67 13.76 11.24 13.18C11.39 13.03 13.95 10.7 14 10.49C14.0069 10.4582 14.006 10.4252 13.9973 10.3938C13.9886 10.3624 13.9724 10.3337 13.95 10.31C13.89 10.26 13.81 10.28 13.74 10.29C13.65 10.31 12.25 11.24 9.52 13.08C9.12 13.35 8.76 13.49 8.44 13.48C8.08 13.47 7.4 13.28 6.9 13.11C6.3 12.91 5.83 12.8 5.87 12.45C5.89 12.27 6.08 12.09 6.55 11.9C9.47 10.63 11.41 9.79 12.38 9.39C15.16 8.23 15.73 8.03 16.11 8.03C16.19 8.03 16.38 8.05 16.5 8.15C16.61 8.23 16.63 8.34 16.64 8.42C16.63 8.48 16.64 8.66 16.64 8.8Z"/>
                                </svg>
                            </a>
                            <a href="#" class="social-icon" title="YouTube">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                                    <path d="M19.67 8.14C19.58 7.84 19.39 7.57 19.13 7.37C18.87 7.17 18.55 7.06 18.22 7.05C16.31 6.96 15.2 6.95 12 6.95C8.8 6.95 7.69 6.96 5.78 7.05C5.45 7.06 5.13 7.17 4.87 7.37C4.61 7.57 4.42 7.84 4.33 8.14C4.23 8.55 4.18 9.04 4.18 9.55V14.45C4.18 14.96 4.23 15.45 4.33 15.86C4.42 16.16 4.61 16.43 4.87 16.63C5.13 16.83 5.45 16.94 5.78 16.95C7.69 17.04 8.8 17.05 12 17.05C15.2 17.05 16.31 17.04 18.22 16.95C18.55 16.94 18.87 16.83 19.13 16.63C19.39 16.43 19.58 16.16 19.67 15.86C19.77 15.45 19.82 14.96 19.82 14.45V9.55C19.82 9.04 19.77 8.55 19.67 8.14ZM10.8 12V9.55L14.4 10.78L10.8 12Z"/>
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Колонка с меню -->
                <div class="col-lg-4 col-md-6 mb-4">
                    <h5 class="text-white mb-4">Навигация</h5>
                    <ul class="footer-menu list-unstyled">
                        <li class="mb-2">
                            <a href="<?= Yii::$app->homeUrl ?>" class="footer-link">
                                🏠 Главная
                            </a>
                        </li>
                        <?php if (Yii::$app->user->isGuest): ?>
                            <li class="mb-2">
                                <a href="<?= Yii::$app->urlManager->createUrl(['/site/register'])?>" class="footer-link">
                                    📝 Регистрация
                                </a>
                            </li>
                            <li class="mb-2">
                                <a href="<?= Yii::$app->urlManager->createUrl(['/site/login'])?>" class="footer-link">
                                    🔐 Авторизация
                                </a>
                            </li>
                        <?php else: ?>
                            <li class="mb-2">
                                <a href="<?= Yii::$app->urlManager->createUrl(['/site/requests'])?>" class="footer-link">
                                    📋 Мои заявки
                                </a>
                            </li>
                            <li class="mb-2">
                                <a href="<?= Yii::$app->urlManager->createUrl(['/site/games'])?>" class="footer-link">
                                    🎯 Игры
                                </a>
                            </li>
                            <?php if (Yii::$app->user->identity->isAdmin()): ?>
                                <li class="mb-2">
                                    <a href="<?= Yii::$app->urlManager->createUrl(['/admin/index'])?>" class="footer-link">
                                        ⚙️ Админ-панель
                                    </a>
                                </li>
                            <?php endif; ?>
                        <?php endif; ?>
                    </ul>
                </div>

                <!-- Колонка с правовой информацией -->
                <div class="col-lg-4 col-md-12 mb-4">
                    <h5 class="text-white mb-4">Информация</h5>
                    <ul class="footer-menu list-unstyled">
                        <li class="mb-2">
                            <a href="<?= Yii::$app->urlManager->createUrl(['/site/privacy'])?>" class="footer-link">
                                🔒 Политика конфиденциальности
                            </a>
                        </li>

                    </ul>
                </div>
            </div>

            <hr class="my-4" style="border-color: var(--border-color);">

            <!-- Нижняя часть футера -->
            <div class="row align-items-center">
                <div class="col-md-6 text-center text-md-start mb-3 mb-md-0">
                    <p class="mb-0" style="color: var(--text-secondary);">
                        &copy; <?= date('Y') ?> Настольные игры. Все права защищены.
                    </p>
                </div>

            </div>
        </div>
    </footer>

    <?php $this->endBody() ?>
    </body>
    </html>
<?php $this->endPage() ?>