<?php

namespace app\models;

use yii\db\ActiveRecord;

class Review extends ActiveRecord
{
    public static function tableName()
    {
        return 'review';
    }

    public function rules()
    {
        return [
            [['user_id', 'request_id', 'text'], 'required'],
            [['user_id', 'request_id'], 'integer'],
            [['text'], 'string'],
            [['created_at'], 'safe'],
        ];
    }

    public function getRequest()
    {
        return $this->hasOne(Request::class, ['id' => 'request_id']);
    }



    public function getUser()
    {
        return $this->hasOne(User::class, ['id' => 'user_id']);
    }
}
