<?php

namespace app\models;

use yii\db\ActiveRecord;

class Request extends ActiveRecord
{
    public $agree;

    public static function tableName()
    {
        return 'request';
    }

    public function rules()
    {
        return [
            [['game_type'], 'required'],
            [['game_name', 'game_id'], 'safe'],   // ← ВАЖНО
            [['game_type', 'game_name', 'game_date', 'game_time', 'address', 'price', 'payment_method', 'player_status', 'game_id', 'game_schedule_id'], 'required'],
            ['game_name', 'string', 'min' => 1],
            ['game_schedule_id', 'integer'],

            ['agree', 'boolean'],
            ['agree', 'compare', 'compareValue' => 1, 'message' => 'Необходимо согласие'],
            ['game_date', 'validateDateTime'],
        ];
    }


    public function validateDateTime($attribute, $params)
    {
        if (!$this->game_date || !$this->game_time) {
            return;
        }

        $selected = strtotime($this->game_date . ' ' . $this->game_time);
        if ($selected < time()) {
            $this->addError($attribute, 'Нельзя записаться на прошедшую дату и время');
        }
    }

    public function getGameSchedule()
    {
        return $this->hasOne(GameSchedule::class, ['id' => 'game_schedule_id']);
    }

    public function getUser()
    {
        return $this->hasOne(User::class, ['id' => 'user_id']);
    }

    public function getReview()
    {
        return $this->hasOne(Review::class, ['request_id' => 'id']);
    }

}
