<?php

namespace app\models;

use yii\base\Model;

class RegisterForm extends Model
{
    public $fio;
    public $phone;
    public $email;
    public $password;
    public $password_repeat;
    public $agree;

    public function rules() {
        return [
            [['fio','phone','email','password','password_repeat','agree'], 'required'],
            ['fio', 'match', 'pattern'=>'/^[А-Яа-я\s]+$/u'],
            ['phone', 'match', 'pattern'=>'/^8\(\d{3}\)\d{3}-\d{2}-\d{2}$/'],
            ['email', 'email'],
            ['password', 'string', 'min'=>8],
            ['password_repeat', 'compare', 'compareAttribute'=>'password'],
            ['agree', 'boolean'],
            ['agree', 'compare', 'compareValue'=>1]
        ];
    }
    public function attributeLabels()
    {
        return [
            'fio' => 'ФИО',
            'phone' => 'Телефон',
            'email' => 'E-mail',
            'password' => 'Пароль',
            'password_repeat' => 'Повтор пароля',
            'agree' => 'Согласие с правилами',
        ];
    }

    public function register() {
        if (!$this->validate()) return false;

        $user = new User();
        $user->fio = $this->fio;
        $user->phone = $this->phone;
        $user->email = $this->email;
        $user->password_hash = \Yii::$app->security->generatePasswordHash($this->password);
        $user->auth_key = \Yii::$app->security->generateRandomString();

        return $user->save();
    }
}
