<?php

namespace app\controllers;

use app\models\GameSchedule;
use app\models\Review;
use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;
use app\models\RegisterForm;
use app\models\LoginForm;
use app\models\Request;

class SiteController extends Controller
{
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'rules' => [
                    ['allow' => true, 'actions' => ['index', 'login', 'register']],
                    ['allow' => true, 'roles' => ['@']]
                ]
            ]
        ];
    }

    public function actionIndex()
    {
        // График игр на месяц
        $games = \app\models\GameSchedule::find()
            ->where(['>=', 'game_date', date('Y-m-d')])
            ->orderBy(['game_date' => SORT_ASC])
            ->limit(10)
            ->all();

        // Отзывы
        $reviews = \app\models\Review::find()
            ->orderBy(['created_at' => SORT_DESC])
            ->limit(5)
            ->all();

        return $this->render('index', [
            'games' => $games,
            'reviews' => $reviews,
        ]);
    }



    public function actionRegister()
    {
        $model = new RegisterForm();
        if ($model->load(Yii::$app->request->post()) && $model->register()) {
            return $this->redirect(['login']);
        }
        return $this->render('register', ['model' => $model]);
    }

    public function actionLogin()
    {
        $model = new LoginForm();
        if ($model->load(Yii::$app->request->post()) && $model->login()) {
            return $this->redirect(['requests']);
        }
        return $this->render('login', ['model' => $model]);
    }

    public function actionRequests()
    {
        $requests = Request::find()->where(['user_id' => Yii::$app->user->id])->all();
        return $this->render('requests', ['requests' => $requests]);
    }

    // SiteController.php
    public function actionUpcomingGames()
    {

    }

    public function actionCreateRequest($id)
    {
        $user = Yii::$app->user->identity;

        // Ищем выбранную игру в расписании
        $game = \app\models\GameSchedule::findOne($id);
        if (!$game) {
            throw new \yii\web\NotFoundHttpException('Игра не найдена');
        }

        $model = new \app\models\Request();
        $model->user_id = $user->id;
        $model->game_schedule_id = $game->id;

        if ($model->load(Yii::$app->request->post())) {

            // Подставляем данные из GameSchedule
            $model->game_type = $game->game_type;
            $model->game_name = $game->game_name;
            $model->game_date = $game->game_date;
            $model->game_time = $game->game_time;
            $model->address = $game->address;
            $model->price = $game->price;

            if ($model->load(Yii::$app->request->post())) {
                $model->user_id = $user->id;
                $model->game_schedule_id = $game->id;

                if ($model->save()) {
                    Yii::$app->session->setFlash('success', 'Вы успешно записались на игру!');
                    return $this->redirect(['site/requests']);
                } else {
                    Yii::error($model->errors);
                    Yii::$app->session->setFlash('error', 'Ошибка при сохранении заявки');
                }
            }


            if ($model->save()) {
                Yii::$app->session->setFlash('success', 'Вы успешно записались на игру!');
                return $this->redirect(['site/requests']);
            } else {
                // Для отладки выводим ошибки
                Yii::error($model->errors);
                Yii::$app->session->setFlash('error', 'Ошибка при сохранении заявки. Смотри лог.');
            }
        }

        return $this->render('create-request', [
            'model' => $model,
            'user' => $user,
            'game' => $game,
        ]);
    }

    public function actionReview($request_id)
    {
        $request = Request::findOne($request_id);

        if (!$request) {
            throw new \yii\web\NotFoundHttpException('Заявка не найдена');
        }

        $model = new Review();
        $model->user_id = Yii::$app->user->id;
        $model->request_id = $request->id;

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            Yii::$app->session->setFlash('success', 'Отзыв успешно сохранён');
            return $this->redirect(['site/requests']);
        }

        return $this->render('review', [
            'model' => $model,
            'request' => $request,
        ]);
    }


    public function actionGameNames()
    {
        $out = [];
        $post = Yii::$app->request->post('depdrop_parents');
        if ($post != null) {
            $type = $post[0];
            $games = [
                'классические' => ['Шахматы', 'Шашки', 'Нарды', 'Домино'],
                'карточные' => ['Шакал', 'Тако, кот, коза, сыр, пицца', 'Взрывные котята', 'Свинтус', 'Мафия', 'Бункер', 'Сопротивление'],
                'экономические' => ['Монополия', 'Крысиные бега', 'Маракайбо'],
                'стратегии' => ['Каркассон', 'Шакал', 'Почта', 'Улей', 'Битва за Рокуган', 'Иван Грозный: Первый царь'],
                'для детей' => ['Кубопрыги', 'Фотовечеринка', 'Средневековая академия'],
            ];
            if (isset($games[$type])) {
                foreach ($games[$type] as $game) {
                    $out[] = ['id' => $game, 'name' => $game];
                }
            }
            return Json::encode(['output'=>$out, 'selected'=>'']);
        }
        return Json::encode(['output'=>'', 'selected'=>'']);
    }
    public function actionLogout()
    {
        Yii::$app->user->logout();
        return $this->goHome();
    }

    public function actionGames()
    {
        $games = GameSchedule::find()
            ->where(['>=', 'game_date', date('Y-m-d')])
            ->orderBy(['game_date' => SORT_ASC])
            ->all();

        return $this->render('games', [
            'games' => $games
        ]);
    }

}
